from django.contrib import admin
from .models import Setting, AndroidVersion, IOSVersion, FirebaseVersion


class SettingAdmin(admin.ModelAdmin):
    list_display = ('id', 'sms_gateway')
    list_editable = ('sms_gateway',)

    def has_add_permission(self, request):
        return not Setting.objects.exists()

    def has_delete_permission(self, request, obj=None):
        return False


class IOSVersionAdmin(admin.ModelAdmin):
    list_display = ('id', 'version')
    list_editable = ('version',)

    def has_add_permission(self, request):
        return not IOSVersion.objects.exists()

    def has_delete_permission(self, request, obj=None):
        return False


class AndroidVersionAdmin(admin.ModelAdmin):
    list_display = ('id', 'version')
    list_editable = ('version',)

    def has_add_permission(self, request):
        return not AndroidVersion.objects.exists()

    def has_delete_permission(self, request, obj=None):
        return False


class FirebaseVersionAdmin(admin.ModelAdmin):
    list_display = ('id', 'version')
    list_editable = ('version',)

    def has_add_permission(self, request):
        return not FirebaseVersion.objects.exists()

    def has_delete_permission(self, request, obj=None):
        return False


admin.site.register(Setting, SettingAdmin)
admin.site.register(AndroidVersion, AndroidVersionAdmin)
admin.site.register(IOSVersion, IOSVersionAdmin)
admin.site.register(FirebaseVersion, FirebaseVersionAdmin)
