# Django
from django.shortcuts import get_object_or_404

# Django Rest Framework
from rest_framework.decorators import action
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response
from rest_framework.viewsets import GenericViewSet
from rest_framework.mixins import CreateModelMixin

# Project
from .serializers import RoomSerializer
from .models import Room


class RoomViewSet(CreateModelMixin, GenericViewSet):
    permission_classes = (IsAuthenticated,)
    serializer_class = RoomSerializer

    @action(methods=['GET'], detail=False)
    def me(self, request, *args, **kwargs):
        instance = get_object_or_404(Room, user=request.user)
        serializer = self.get_serializer(instance)
        return Response(serializer.data)
