# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import ViewSetTestCase, AuthTestCase


class RoomMobileTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'rooms.yaml',
        'user.yaml'
    ]

    url = 'mobile:rooms-%s'

    def setUp(self):
        self._auth_admin()

    def test_unauth(self):
        self.client.credentials()

        response = self._create({})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

        response = self._retrieve({'method': 'me'})
        self.assertEqual(response.status_code, status.HTTP_403_FORBIDDEN)

    def test_create(self):
        response = self._create(data={'room_id': 'room3'})
        self.assertEqual(response.status_code, status.HTTP_201_CREATED)
        self.assertEqual(response.data, {'room_id': 'room3'})

    def test_create_fail(self):
        response = self._create(data={'room_id': 'room3'})
        self.assertEqual(response.status_code, status.HTTP_201_CREATED)
        self.assertEqual(response.data, {'room_id': 'room3'})

    def test_me(self):
        response = self._retrieve({'method': 'me'})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data, {'room_id': 'room2'})

    def test_me_404(self):
        self._auth_saferoad()
        response = self._retrieve({'method': 'me'})
        self.assertEqual(response.status_code, status.HTTP_404_NOT_FOUND)
