# Django
from django.db import transaction

# Django Rest Framework
from rest_framework import serializers

# Project
from .models import Room


class RoomSerializer(serializers.ModelSerializer):
    class Meta:
        model = Room
        fields = ('room_id',)

    @transaction.atomic
    def create(self, validated_data):
        user = self.context['request'].user
        instance, _ = Room.objects.update_or_create(
            user=user,
            defaults=validated_data
        )
        return instance
