# Django Rest Framework
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status

# Project
from .serializers.report import ReportSerializer
from .serializers.offence import OffenceSerializer
from .permissions import IsEjarima
from apps.logs.utils import log_http_input_request


class ReportWebhook(APIView):
    permission_classes = (IsEjarima,)

    def post(self, request):
        serializer = ReportSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        serializer.save()

        response = Response(status=status.HTTP_200_OK)
        log_http_input_request(request, response)
        return response


class OffenceWebhook(APIView):
    permission_classes = (IsEjarima,)

    def post(self, request):
        serializer = OffenceSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        serializer.save()

        response = Response(status=status.HTTP_200_OK)
        log_http_input_request(request, response)
        return response
