# Django Rest Framework
from rest_framework import serializers

# Project
from apps.notifications.services import (
    NotificationTemplate, send_report_notification
)
from ...models import Report


class ReportSerializer(serializers.Serializer):
    id = serializers.CharField()
    status = serializers.ChoiceField(choices=Report.STATUS_CHOICES)

    def create(self, validated_data):
        obj = Report.objects.filter(ejarima_id=validated_data['id']).first()
        if not obj:
            return validated_data
        obj.status = validated_data['status']
        obj.save()

        send_report_notification(obj, NotificationTemplate.REPORT_REVIEWED)
        return obj
