# Django Rest Framework
from rest_framework import status

# Pypi: requests
from apps.shared.utils import requests

# Project
from apps.gauth.models import User


class Ejarima:
    URL = 'https://video.yhxbb.uz'

    def __init__(self):
        self._create_access_token()

    def _create_access_token(self):
        data = {
            'client_id': '35da649c-b727-43c3-bdcf-b0149718fefe',
            'grant_type': 'client_credentials',
            'client_secret': 'JZRwtsAnyh5LyXTcMCyKm2dWXx4cbqxg'
        }
        response = requests.post(
            self.URL + '/oauth/access_token',
            data=data,
            verify=False
        )
        msg = 'Fail request access token'
        assert response.status_code == status.HTTP_200_OK, msg
        self.access_token = response.json()['access_token']

    @property
    def report_form(self):
        response = requests.get(
            self.URL + '/api/oauth/report/form?locale=ru',
            verify=False,
            headers={'Authorization': 'Bearer %s' % self.access_token}
        )
        msg = 'Fail request report form'
        assert response.status_code == status.HTTP_200_OK, msg
        return response.json()

    def upload_video(self, video_name, video_bytes):
        ext = video_name.split('.')[-1]
        response = requests.post(
            self.URL + '/api/oauth/report/video',
            verify=False,
            headers={'Authorization': 'Bearer %s' % self.access_token},
            files=[
                (
                    'video',
                    (video_name, video_bytes, 'video/%s' % ext)
                )
            ]
        )
        msg = 'Fail request report form. %s' % response.text
        assert response.status_code == status.HTTP_200_OK, msg
        return response.json()

    def _create_user_citizen(self, user: User):
        data = {
            'phone': user.phone,
            'first_name': user.first_name,
            'last_name': user.last_name
        }
        response = requests.post(
            self.URL + '/api/oauth/citizens',
            verify=False,
            headers={'Authorization': 'Bearer %s' % self.access_token},
            json=data
        )
        msg = 'Fail create citizen. %s' % response.text
        assert response.status_code in [
            status.HTTP_200_OK, status.HTTP_409_CONFLICT
        ], msg

        response = response.json()
        user.ejarima_id = response['id']
        user.save()

        return response

    def create_report(self, data, user: User):
        citizen_id = user.ejarima_id
        if not citizen_id:
            citizen_id = self._create_user_citizen(user)['id']

        response = requests.post(
            self.URL + '/api/oauth/reports',
            verify=False,
            headers={
                'Authorization': 'Bearer %s' % self.access_token,
                'Citizen-id': citizen_id,
            },
            json=data
        )
        msg = 'Fail request create report. %s' % response.text
        assert response.status_code == status.HTTP_200_OK, msg
        return response.json()

    def get_offences(self, report_pk):
        response = requests.get(
            self.URL + '/api/oauth/reports/%s/offenses?size=100' % report_pk,
            verify=False,
            headers={'Authorization': 'Bearer %s' % self.access_token}
        )
        msg = 'Fail request offences.'
        assert response.status_code == status.HTTP_200_OK, msg
        return response.json()
