# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import ViewSetTestCase, AuthTestCase
from apps.shared import messages
from ..models import Reward, Report


class FundMobileTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'funds.yaml'
    ]

    url = 'mobile:fund-%s'

    def test_unauth(self):
        self.client.credentials()

        response = self._list({})
        self.assertEqual(response.status_code, status.HTTP_200_OK)

    def test_list(self):
        self.client.credentials()
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(
            response.data['results'],
            [
                {
                    "id": 5,
                    "name": "Вақф - \"Хайрия\"",
                    "link": "http://vaqf.uz"
                },
                {
                    "id": 4,
                    "name": "Вақф - \"Вақф\"",
                    "link": "http://vaqf.uz"
                },
                {
                    "id": 3,
                    "name": "Меҳрли қўллар",
                    "link": "http://mehrli.uz"
                },
                {
                    "id": 2,
                    "name": "Эзгу Aмал",
                    "link": "https://ezguamal.com/"
                },
                {
                    "id": 1,
                    "name": "Возможно всё",
                    "link": "https://t.me/vozmojnovsyo"
                }
            ]
        )
