# Django
from django.db import transaction
from django.conf import settings

# Project
from apps.geo.services import address_create
from .models import Report, Reward, Offence
from .tasks import send_to_ejarima


@transaction.atomic
def create_report(**kwargs):
    reward = kwargs.pop('reward')
    offences = kwargs.pop('offences')

    address = address_create(**kwargs.pop('address'))
    report = Report.objects.create(address=address, **kwargs)
    Reward.objects.create(**reward, report=report)
    Offence.objects.bulk_create(Offence(**i, report=report) for i in offences)

    if settings.ENV == 'testing':
        report.status = Report.REVIEWED
        report.save()
    else:
        send_to_ejarima.delay(report.id)

    return report
