# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Reward(BaseModel):
    PHONE = 'phone'
    FUND = 'fund'
    CARD = 'card'
    NO_REWARD = 'no-reward'
    BANK = 'bank'

    KIND_CHOICES = (
        (PHONE, 'Phone'),
        (FUND, 'Fund'),
        (CARD, 'Card'),
        (NO_REWARD, 'No reward'),
        (BANK, 'Bank transfer'),
    )

    kind = models.CharField(max_length=20, choices=KIND_CHOICES)
    report = models.OneToOneField(
        'reports.Report',
        on_delete=models.CASCADE,
        related_name='reward'
    )
    enter = models.CharField(max_length=255, blank=True)


class Fund(BaseModel):
    name = models.CharField(max_length=200)
    link = models.URLField(max_length=200)
