# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class Report(BaseModel):
    CREATED = 'created'
    REVIEWED = 'reviewed'

    STATUS_CHOICES = (
        (CREATED, 'Created'),
        (REVIEWED, 'Reviewed'),
    )

    REAR = 'rear'
    REMAKE = 'remake'
    SEQUEL = 'sequel'

    EXTRA_VIDEO_TYPE_CHOICES = (
        (REAR, 'Rear'),
        (REMAKE, 'Remake'),
        (SEQUEL, 'Sequel')
    )

    status = models.CharField(
        max_length=20,
        choices=STATUS_CHOICES,
        default=CREATED
    )
    video = models.ForeignKey(
        'files.File',
        on_delete=models.PROTECT,
        related_name='video_report'
    )
    extra_video = models.ForeignKey(
        'files.File',
        on_delete=models.PROTECT,
        related_name='extra_video_report',
        null=True
    )
    extra_video_type = models.CharField(
        max_length=30,
        choices=EXTRA_VIDEO_TYPE_CHOICES,
        default=SEQUEL
    )

    address = models.ForeignKey('geo.Address', on_delete=models.PROTECT)
    incident_datetime = models.DateTimeField()
    created_by = models.ForeignKey(
        'gauth.User',
        on_delete=models.CASCADE
    )
    ejarima_id = models.CharField(max_length=255, null=True, unique=True)
    ejarima_number = models.IntegerField(null=True, unique=True)
