# Django
from django.db import models

# Pypi: django-parler
from parler.models import TranslatedFields

# Project
from apps.shared.models import BaseTranslateModel


class Offence(BaseTranslateModel):
    CREATED = 'created'
    REJECTED = 'rejected'
    ACCEPTED = 'accepted'
    FAILED = 'failed'
    FORWARDED = 'forwarded'
    DISMISSED = 'dismissed'
    PAID = 'paid'

    STATUS_CHOICES = (
        (CREATED, 'Created'),
        (REJECTED, 'Rejected'),
        (ACCEPTED, 'Accepted'),
        (FAILED, 'Failed'),
        (FORWARDED, 'Forwarded'),
        (DISMISSED, 'Dismissed'),
        (PAID, 'Paid')
    )

    ABSENT = 'absent'
    IGNORED = 'ignored'
    REWARD_STATUS = (
        (CREATED, 'Created'),
        (PAID, 'Paid'),
        (ABSENT, 'Absent'),
        (IGNORED, 'Ignored'),
        (FAILED, 'Failed'),
    )

    translations = TranslatedFields(
        reject_text=models.CharField(max_length=655, blank=True),
        reject_alias=models.CharField(max_length=255, blank=True),
    )

    status = models.CharField(max_length=20, default=CREATED)
    report = models.ForeignKey(
        'reports.Report',
        on_delete=models.CASCADE,
        related_name='offences'
    )
    vehicle_id = models.CharField(max_length=20)
    testimony = models.CharField(max_length=255)

    extra_response = models.CharField(max_length=655, null=True)
    reward_status = models.CharField(
        max_length=30,
        default=ABSENT,
        choices=REWARD_STATUS
    )

    ejarima_id = models.CharField(max_length=255, null=True, unique=True)
    ejarima_number = models.IntegerField(null=True, unique=True)
