# Django Rest Framework
from rest_framework import mixins
from rest_framework.viewsets import GenericViewSet, ReadOnlyModelViewSet
from rest_framework.permissions import IsAuthenticated

# Project
from .serializers.report import ReportSerializer, ReportListSerializer
from .serializers.offence import FundSerializer
from ..models import Report, Fund


class ReportViewSet(mixins.ListModelMixin,
                    mixins.RetrieveModelMixin,
                    mixins.CreateModelMixin,
                    GenericViewSet):
    permission_classes = (IsAuthenticated,)

    def get_queryset(self):
        user = self.request.user
        return Report.objects.filter(created_by=user)

    def get_serializer_class(self):
        if self.action == 'list':
            return ReportListSerializer
        return ReportSerializer


class FundViewSet(ReadOnlyModelViewSet):
    queryset = Fund.objects.all()
    serializer_class = FundSerializer
