# Generated by Django 3.1.4 on 2021-02-12 13:03

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import parler.fields
import parler.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('files', '0003_auto_20201216_0959'),
        ('geo', '0003_auto_20201218_0636'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Fund',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('link', models.URLField()),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
        ),
        migrations.CreateModel(
            name='Report',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('created', 'Created'), ('reviewed', 'Reviewed')], default='created', max_length=20)),
                ('extra_video_type', models.CharField(choices=[('rear', 'Rear'), ('remake', 'Remake'), ('sequel', 'Sequel')], default='sequel', max_length=30)),
                ('incident_datetime', models.DateTimeField()),
                ('ejarima_id', models.CharField(max_length=255, null=True, unique=True)),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='geo.address')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('extra_video', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='extra_video_report', to='files.file')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='video_report', to='files.file')),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
        ),
        migrations.CreateModel(
            name='Reward',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('kind', models.CharField(choices=[('phone', 'Phone'), ('fund', 'Fund'), ('card', 'Card'), ('no-reward', 'No reward'), ('bank', 'Bank transfer')], max_length=20)),
                ('enter', models.CharField(blank=True, max_length=255)),
                ('report', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='reward', to='reports.report')),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
        ),
        migrations.CreateModel(
            name='Offence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('status', models.CharField(default='created', max_length=20)),
                ('vehicle_id', models.CharField(max_length=20)),
                ('testimony', models.CharField(max_length=255)),
                ('ejarima_id', models.CharField(max_length=255, null=True, unique=True)),
                ('report', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='offences', to='reports.report')),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='OffenceTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('reject_text', models.CharField(blank=True, max_length=655)),
                ('reject_alias', models.CharField(blank=True, max_length=255)),
                ('master', parler.fields.TranslationsForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='reports.offence')),
            ],
            options={
                'verbose_name': 'offence Translation',
                'db_table': 'reports_offence_translation',
                'db_tablespace': '',
                'managed': True,
                'default_permissions': (),
                'unique_together': {('language_code', 'master')},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
