# Django
from django.core.management.base import BaseCommand
from django.db import transaction

# Project
from apps.reports.utils.ejarima import Ejarima
from apps.geo.models import Region, District
from apps.reports.models import Fund


class Command(BaseCommand):
    help = 'Displays current time'

    @transaction.atomic
    def handle(self, *args, **kwargs):
        ejarima = Ejarima()

        data = ejarima.report_form
        areas = data['areas']
        funds = data['funds']

        for key_fund in funds.keys():
            Fund.objects.get_or_create(name__iexact=key_fund, defaults={
                'name': key_fund,
                'link': funds[key_fund]
            })

        # for area in areas:
        #     districts = area['districts']
        #     name = area['name'].replace('Город ', '')
        #     region, _ = Region.objects.get_or_create(
        #         name__iexact=name,
        #         defaults={
        #             'ejarima_id': area['id'],
        #             'name': name
        #         }
        #     )
        #
        #     for district in districts:
        #         name = district['name'].replace('Город ', '')
        #
        #         District.objects.get_or_create(
        #             name__iexact=name,
        #             defaults={
        #                 'ejarima_id': district['id'],
        #                 'region': region,
        #                 'name': name
        #             }
        #         )
