# Django
from django.utils.translation import gettext as _
from django.db import transaction

# Project
from .models import Problem, Vote


@transaction.atomic
def vote_problem(problem: Problem, user):
    vote = Vote.objects.filter(problem=problem, user=user).first()

    if vote:
        vote.delete()
        problem.votes_count -= 1
        problem.save()
    else:
        Vote.objects.create(problem=problem, user=user)
        problem.votes_count += 1
        problem.save()

    return {
        'votes_count': problem.votes_count
    }
