# Django
from django.db import models

# Project
from apps.shared.models import BaseModel, ModifyModel


class Problem(BaseModel):
    TRAFFIC_LIGHT = 'traffic_light'
    ROAD_SURFACE = 'road_surface'
    MARKUP = 'markup'
    ROAD_SIGN = 'road_sign'
    OTHER = 'other'
    KIND_CHOICES = (
        (TRAFFIC_LIGHT, 'Traffic light'),
        (ROAD_SURFACE, 'Road, surface'),
        (MARKUP, 'Markup'),
        (ROAD_SIGN, 'Road sign'),
        (OTHER, 'Other')
    )

    MODERATING = 'moderating'
    NEW = 'new'
    IN_PROGRESS = 'in_progress'
    ACCEPTED = 'accepted'
    REJECTED = 'rejected'
    STATUS_CHOICES = (
        (MODERATING, 'Moderating'),
        (NEW, 'New'),
        (IN_PROGRESS, 'In progress'),
        (ACCEPTED, 'Accepted'),
        (REJECTED, 'Rejected')
    )

    hash_key = models.CharField(
        max_length=10,
        unique=True,
        null=True
    )
    description = models.CharField(max_length=655)
    kind = models.CharField(max_length=30, choices=KIND_CHOICES)
    status = models.CharField(
        max_length=30,
        choices=STATUS_CHOICES,
        default=MODERATING
    )
    photos = models.ManyToManyField('files.File')
    address = models.OneToOneField(
        'geo.Address',
        on_delete=models.PROTECT
    )
    created_by = models.ForeignKey(
        'gauth.User',
        on_delete=models.PROTECT,
        related_name='problems'
    )
    comment = models.TextField(blank=True)
    votes_count = models.PositiveIntegerField(default=0)


class Vote(ModifyModel):
    problem = models.ForeignKey(
        Problem,
        on_delete=models.CASCADE,
        related_name='votes'
    )
    user = models.ForeignKey('gauth.User', on_delete=models.CASCADE)

    class Meta:
        unique_together = ('problem', 'user')
