# Generated by Django 3.1.3 on 2020-12-11 11:22

from django.conf import settings
import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('geo', '0001_initial'),
        ('files', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('latitude', models.FloatField()),
                ('longitude', models.FloatField()),
                ('point', django.contrib.gis.db.models.fields.PointField(srid=4326)),
                ('landmark', models.CharField(blank=True, max_length=255)),
                ('address', models.CharField(max_length=400)),
                ('region', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='geo.region')),
            ],
        ),
        migrations.CreateModel(
            name='Problem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('description', models.CharField(max_length=655)),
                ('kind', models.CharField(choices=[('traffic_light', 'Traffic light'), ('road_surface', 'Road, surface'), ('markup', 'Markup'), ('road_sign', 'Road sign'), ('other', 'Other')], max_length=30)),
                ('address', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='problems.address')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='problems', to=settings.AUTH_USER_MODEL)),
                ('photos', models.ManyToManyField(to='files.File')),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
        ),
        migrations.CreateModel(
            name='Like',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_like', models.BooleanField()),
                ('problem', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='likes', to='problems.problem')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
