# Django
from django.db.models import Q, Count
from django.contrib.gis.geos import Point

# Pypi: django-filter
from django_filters import rest_framework as filters

# Project
from .models import Problem


class ProblemFilter(filters.FilterSet):
    distance = filters.CharFilter(
        method='get_distance',
        help_text='param value: {lon},{lat},{distance}. '
                  'distance=41.327307,69.282998,1000'
                  '-> return all problems within a radius of 1000m'
    )

    def get_distance(self, queryset, name, value):
        if len(data := value.split(',')) == 3:
            pnt = Point(float(data[0]), float(data[1]))
            return queryset.filter(
                address__point__distance_lte=(pnt, data[2])
            )
        return queryset

    class Meta:
        model = Problem
        fields = ('kind', 'status', 'distance')
