# Django
from django.db.models import Count, Q

# Django Rest Framework
from rest_framework import mixins
from rest_framework.viewsets import GenericViewSet
from rest_framework.permissions import IsAdminUser

# Project
from .serializers import ProblemSerializer, ProblemListSerializer
from ..models import Problem
from ..filter import ProblemFilter


class ProblemViewSet(mixins.ListModelMixin,
                     mixins.UpdateModelMixin,
                     mixins.RetrieveModelMixin,
                     GenericViewSet):
    permission_classes = (IsAdminUser,)
    serializer_class = ProblemSerializer
    filterset_class = ProblemFilter

    def get_queryset(self):
        queryset = Problem.objects.select_related(
            'address__district__region'
        ).order_by('-id')
        return queryset

    def get_serializer_class(self):
        if self.action == 'list':
            return ProblemListSerializer
        return ProblemSerializer
