# Django Rest Framework
from rest_framework import serializers

# Project
from ..models import NotificationContent, Notification


class NotificationContentSerializer(serializers.ModelSerializer):
    action = serializers.CharField(source='template.action')

    class Meta:
        model = NotificationContent
        fields = (
            'id',
            'action',
            'content',
        )


class NotificationSerializer(serializers.ModelSerializer):
    notification_content = NotificationContentSerializer(read_only=True)

    class Meta:
        model = Notification
        fields = (
            'id',
            'notification_content',
            'is_read',
            'created_date'
        )
        read_only_fields = ('created_date',)


class NotificationCountSerializer(serializers.Serializer):
    total_count = serializers.IntegerField()
    unread_count = serializers.IntegerField()
