# Generated by Django 3.1.4 on 2021-05-16 08:55

from django.db import migrations


def adapt_notification(apps, schema_editor):
    # We get the model from the versioned app registry;
    # if we directly import it, it'll be the wrong version
    NotificationContent = apps.get_model("notifications", "NotificationContent")


    contents = NotificationContent.objects.all()
    for content in contents:
        content.set_current_language(content.language)
        content.content = content.old_content
        content.save()


class Migration(migrations.Migration):
    dependencies = [
        ('notifications', '0006_auto_20210516_1343'),
    ]

    operations = [
        migrations.RunPython(adapt_notification),
    ]
