# Generated by Django 3.1.4 on 2021-03-19 09:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import parler.fields
import parler.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='NotificationTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('action', models.CharField(choices=[('partial_paid_fine', 'Partial paid fine'), ('completely_paid_fine', 'Completely paid fine'), ('new_fine', 'New Fine')], max_length=50, unique=True)),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='NotificationContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('content', models.JSONField(default=dict)),
                ('language', models.CharField(choices=[('uz', 'Uzbek'), ('ru', 'Russian')], max_length=4)),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('template', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='notifications.notificationtemplate')),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('is_read', models.BooleanField(default=False)),
                ('notification_content', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.notificationcontent')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
            },
        ),
        migrations.CreateModel(
            name='NotificationTemplateTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('title', models.CharField(max_length=100)),
                ('body', models.CharField(max_length=2048)),
                ('master', parler.fields.TranslationsForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='notifications.notificationtemplate')),
            ],
            options={
                'verbose_name': 'notification template Translation',
                'db_table': 'notifications_notificationtemplate_translation',
                'db_tablespace': '',
                'managed': True,
                'default_permissions': (),
                'unique_together': {('language_code', 'master')},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
