# Stdlib
import json
from datetime import datetime

# Project
from .mongo import mongo

db = mongo.log


def log_http_output_request(response, **kwargs):
    collection = db.http_output
    request_body = response.request.body

    if request_body:
        request_body = request_body.decode('utf8')

    try:
        request_body = json.loads(request_body)
    except (TypeError, OverflowError):
        pass

    try:
        response_body = response.json()
    except Exception as e:
        response_body = response.text

    data = dict(
        request_url=response.url,
        request_body=request_body,
        response_status_code=response.status_code,
        response_body=response_body,
        request_method=response.request.method,
        created_date=datetime.utcnow(),
        response_time=response.elapsed.total_seconds()
    )
    collection.insert_one(data)


def log_http_input_request(request, response):
    collection = db.http_input_v2
    data = dict(
        request_url=request.build_absolute_uri(),
        request_body=request.data or {},
        request_method=request.method,
        response_status_code=response.status_code,
        response_body=response.data or {},
        created_date=datetime.utcnow()
    )
    collection.insert_one(data)


def log_http_output_request_exception(request, response_status, timeout):
    collection = db.http_output
    request_body = request.body

    if request_body:
        request_body = request_body.decode('utf8')

    try:
        request_body = json.loads(request_body)
    except (TypeError, OverflowError):
        pass

    data = dict(
        request_url=request.url,
        request_body=request_body,
        response_status_code=response_status,
        request_method=request.method,
        created_date=datetime.utcnow(),
        response_time=timeout
    )
    collection.insert_one(data)
