import os
from pymongo import MongoClient


class MyMongoClient:
    __instance = None

    @staticmethod
    def getInstance():
        if MyMongoClient.__instance is None:
            MyMongoClient()
        return MyMongoClient.__instance

    def __init__(self, *args, **kwargs):
        if MyMongoClient.__instance is not None:
            raise Exception("This class is a singleton!")
        else:
            if url := os.environ.get('MONGO_URL'):
                MyMongoClient.__instance = MongoClient(url)
            else:
                MyMongoClient.__instance = MongoClient()


mongo = MyMongoClient.getInstance()
