# Django
from django.db import models

# Project
from apps.shared.models import BaseModel


class HttpLog(BaseModel):
    INPUT = 'input'
    OUTPUT = 'output'

    DIRECTION_CHOICES = (
        (INPUT, 'Input'),
        (OUTPUT, 'Output')
    )

    request_url = models.CharField(max_length=800)
    request_body = models.JSONField(null=True)
    request_method = models.CharField(max_length=10)

    response_body = models.JSONField(null=True)
    response_status_code = models.SmallIntegerField()

    direction = models.CharField(
        max_length=10,
        choices=DIRECTION_CHOICES,
        default=OUTPUT
    )
