# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import AuthTestCase, ViewSetTestCase


class FAQPublicTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'faq.yaml',
        'faq_translations.yaml'
    ]

    url = 'public:faq-%s'

    def test_list(self):
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 2)
        self.assertEqual(len(response.data['results']), 2)
        self.assertEqual(
            response.data['results'][0],
            {
                "id": 2,
                "question": "text_ru",
                "answer": "text_ru"
            },
        )

    def test_pagination(self):
        response = self._list({'page_size': 1})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 2)
        self.assertEqual(len(response.data['results']), 1)
