# Django
from django.urls import reverse

# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import AuthTestCase, ViewSetTestCase


class HandbookPublicTest(APITestCase, ViewSetTestCase, AuthTestCase):
    fixtures = [
        'article.yaml',
        'article_translations.yaml'
    ]

    url = 'public:articles-%s'

    def test_list(self):
        response = self._list()
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 72)
        self.assertEqual(len(response.data['results']), 10)
        self.assertEqual(
            response.data['results'][0],
            {
                "id": 72,
                "article": "194",
                "part": 2,
                "body": "Невыполнение законных требований сотрудника "
                        "органов внутренних дел о прекращении правонарушений, "
                        "предъявлении документов для проверки, о следовании "
                        "или явке в орган внутренних дел в указанный срок "
                        "без уважительных причин, об остановке транспортного "
                        "средства, оказании помощи пострадавшим либо иное "
                        "неповиновение законным требованиям сотрудника "
                        "органов внутренних дел, а равно невыполнение "
                        "законных требований других лиц, осуществляющих "
                        "обязанности по охране общественного порядка и "
                        "обеспечению прав и свобод граждан "
                        "(То же правонарушение, совершенное повторно в "
                        "течение года после применения административного "
                        "взыскания)",
                "individual_min_brv": 2.0,
                "individual_max_brv": 3.0,
                "entity_min_brv": None,
                "entity_max_brv": None
            },
        )

    def test_pagination(self):
        response = self._list({'page_size': 5})
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['count'], 72)
        self.assertEqual(len(response.data['results']), 5)
