# Django Rest Framework
from rest_framework.viewsets import ReadOnlyModelViewSet

# Project
from ..models import Article, FAQ
from .serializers import ArticleSerializer, FAQSerializer


class ArticleViewSet(ReadOnlyModelViewSet):
    queryset = Article.objects.all()
    serializer_class = ArticleSerializer


class FAQViewSet(ReadOnlyModelViewSet):
    queryset = FAQ.objects.all()
    serializer_class = FAQSerializer
