# Django Rest Framework
from rest_framework import serializers

# Project
from ..models import Article, FAQ


class ArticleSerializer(serializers.ModelSerializer):
    class Meta:
        model = Article
        fields = (
            'id',
            'article',
            'part',
            'body',
            'individual_min_brv',
            'individual_max_brv',
            'entity_min_brv',
            'entity_max_brv'
        )


class FAQSerializer(serializers.ModelSerializer):
    class Meta:
        model = FAQ
        fields = (
            'id',
            'question',
            'answer'
        )
