# Django
from django.db import models

# Pypi: django-parler
from parler.models import TranslatedFields

# Project
from apps.shared.models import BaseTranslateModel


class Article(BaseTranslateModel):
    translations = TranslatedFields(
        body=models.CharField(max_length=1024)
    )

    article = models.CharField(max_length=10)
    part = models.PositiveIntegerField(null=True)

    individual_min_brv = models.FloatField(null=True)
    individual_max_brv = models.FloatField(null=True)

    entity_min_brv = models.FloatField(null=True)
    entity_max_brv = models.FloatField(null=True)

    class Meta(BaseTranslateModel.Meta):
        constraints = [
            models.UniqueConstraint(
                fields=['article', 'part'],
                condition=models.Q(is_deleted=False),
                name='unique_article_part'
            )
        ]
