# Generated by Django 3.1.4 on 2021-04-09 12:00

from django.db import migrations, models
import django.db.models.deletion
import parler.fields
import parler.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('article', models.CharField(max_length=10)),
                ('part', models.PositiveIntegerField(null=True)),
                ('individual_min_brv', models.FloatField(null=True)),
                ('individual_max_brv', models.FloatField(null=True)),
                ('entity_min_brv', models.FloatField(null=True)),
                ('entity_max_brv', models.FloatField(null=True)),
            ],
            options={
                'ordering': ('-id',),
                'abstract': False,
                'default_permissions': ('list', 'retrieve', 'create', 'update', 'destroy', 'get_history', 'write_history'),
                'unique_together': {('article', 'part')},
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='MinWage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.PositiveIntegerField()),
                ('activate_date', models.DateField(unique=True)),
            ],
            options={
                'ordering': ['-activate_date'],
            },
        ),
        migrations.CreateModel(
            name='ArticleTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('body', models.CharField(max_length=1024)),
                ('master', parler.fields.TranslationsForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='handbooks.article')),
            ],
            options={
                'verbose_name': 'article Translation',
                'db_table': 'handbooks_article_translation',
                'db_tablespace': '',
                'managed': True,
                'default_permissions': (),
                'unique_together': {('language_code', 'master')},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
