import xlrd
from openpyxl import load_workbook

from apps.handbooks.models import Article

# Violation.objects.create()

wb = load_workbook("apps/handbooks/import/AdmKodeksASBT.xlsx")
sh = wb.worksheets[-1]

for row in sh.iter_rows(min_row=3):
    if not row[1].value:
        continue

    if type(row[1].value) == str:
        article, part = row[1].value.split('-')
    else:
        article, part = int(row[1].value), None

    body_ru = row[2].value
    body_uz = row[3].value
    body_oz = row[3].value

    individual_min_brv = row[4].value
    individual_max_brv = None
    if individual_min_brv:
        if type(row[4].value) == str:
            individual_min_brv, individual_max_brv = row[4].value.split('-')
        else:
            individual_min_brv, individual_max_brv = float(row[4].value), None

    entity_min_brv = row[8].value
    entity_max_brv = None
    if entity_min_brv:
        if type(row[8].value) == str:
            entity_min_brv, entity_max_brv = row[8].value.split('-')
        else:
            print(article, part, row[8].value)
            entity_min_brv, entity_max_brv = float(row[8].value), None

    obj = Article.objects.create(
        article=article,
        part=part,
        individual_min_brv=individual_min_brv,
        individual_max_brv=individual_max_brv,
        entity_min_brv=entity_min_brv,
        entity_max_brv=entity_max_brv
    )

    obj.set_current_language('ru')
    obj.body = body_ru
    obj.save()

    obj.set_current_language('uz')
    obj.body = body_uz
    obj.save()

    obj.set_current_language('oz')
    obj.body = body_oz
    obj.save()

    print(article, part)
