# PyPi
from parler.admin import TranslatableAdmin

# Django
from django.contrib import admin

# Project
from apps.handbooks.models import MinWage, FAQ
from apps.gauth.models import User
from apps.cars.models import Fine
from apps.transactions.models import Check


class MinWageAdmin(admin.ModelAdmin):
    list_display = ('id', 'amount', 'activate_date')


class UserAdmin(admin.ModelAdmin):
    fields = ('id', 'phone', 'username', 'sms_code')
    list_display = ('id', 'phone', 'username', 'sms_code')
    readonly_fields = ('id', 'phone', 'username', 'sms_code')
    search_fields = ('phone',)


class FineAdmin(admin.ModelAdmin):
    list_per_page = 20
    fields = ('id', 'pSeryNumber', 'pAmount',
              'pStatus', 'remain', 'parent_id')
    list_display = ('id', 'pSeryNumber', 'pAmount', 'pStatus', 'remain',
                    'parent_id', 'pl_number', 'created_date',
                    'modified_date')
    readonly_fields = ('id', 'pSeryNumber', 'pAmount',
                       'pStatus', 'remain', 'parent_id')
    search_fields = ('pSeryNumber', 'car_detail__cars__user__phone',
                     'car_detail__number')

    def pl_number(self, obj):
        return obj.car_detail.number

    def has_delete_permission(self, request, obj=None):
        return False

    def has_add_permission(self, request):
        return False

    def has_change_permission(self, request, obj=None):
        return False


class CheckAdmin(admin.ModelAdmin):
    list_per_page = 20
    fields = ('id', 'amount', 'result',)
    list_display = ('id', 'amount', 'fine_number', 'card_number', 'user_phone',
                    'transaction', 'created_date')
    readonly_fields = ('id', 'amount', 'result',)
    search_fields = ('id', 'user__phone', 'fine__pSeryNumber')

    def fine_number(self, obj):
        return obj.fine.pSeryNumber

    def card_number(self, obj):
        return obj.bank_card.number

    def user_phone(self, obj):
        return obj.user.phone

    def transaction(self, obj):
        return obj.result.get('tr_id')

    def has_delete_permission(self, request, obj=None):
        return False

    def has_add_permission(self, request):
        return False

    def has_change_permission(self, request, obj=None):
        return False


class FAQAdmin(TranslatableAdmin):
    list_display = ('id', 'question', 'answer')


admin.site.register(MinWage, MinWageAdmin)
admin.site.register(User, UserAdmin)
admin.site.register(Fine, FineAdmin)
admin.site.register(Check, CheckAdmin)
admin.site.register(FAQ, FAQAdmin)
