# Django
from django.urls import reverse

# Django Rest Framework
from rest_framework.test import APITestCase
from rest_framework import status

# Project
from apps.shared.tests import AuthTestCase


class GeocoderMobileTest(APITestCase, AuthTestCase):
    fixtures = [
        'user.yaml',
        'region.yaml',
        'district.yaml',
        'file.yaml',
        'address.yaml',
    ]

    def setUp(self):
        self._auth_admin()

    def test_reverse_tashkent_korasu(self):
        url = reverse(
            'mobile:geocoder_reverse',
            kwargs={'version': 'v1'}
        ) + '?lat=41.335459&lon=69.376377'
        response = self.client.get(url)
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(
            response.data,
            {
                "country": "Узбекистан",
                "region": "Ташкент",
                "district": "Мирзо-Улугбекский район",
                "address": "Ташкент, Мирзо-Улугбекский район, "
                           "Карасу 1 массив, 34"
            }
        )

    def test_reverse_samarkand(self):
        url = reverse(
            'mobile:geocoder_reverse',
            kwargs={'version': 'v1'}
        ) + '?lat=39.654515&lon=66.968847'
        response = self.client.get(url)
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(
            response.data,
            {
                "country": "Узбекистан",
                "region": "Самаркандская область",
                "district": "Самаркандский район",
                "address": "Самаркандская область, Самаркандский район, "
                           "Kuksaray Bridge, Регистан"
            }
        )

    def test_reverse_district_19(self):
        url = reverse(
            'mobile:geocoder_reverse',
            kwargs={'version': 'v1'}
        ) + '?lat=41.312941309863426&lon=69.35199860483408'
        response = self.client.get(url)
        self.assertEqual(response.status_code, status.HTTP_200_OK)

        self.assertEqual(
            response.data,
            {
                "country": "Узбекистан",
                "region": "Ташкентская область",
                "district": "Кибрайский район",
                "address": "Ташкентская область, Кибрайский район"
            }
        )

    def test_search(self):
        url = reverse(
            'mobile:geocoder_search',
            kwargs={'version': 'v1'}
        ) + '?q=ташкент Мирзо-Улугбекский район'
        response = self.client.get(url)
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        self.assertEqual(response.data['type'], 'FeatureCollection')

    def test_reverse_validate_only_uzbekistan(self):
        url = reverse(
            'mobile:geocoder_reverse',
            kwargs={'version': 'v1'}
        ) + '?lat=41.4538339139004&lon=69.16388019919395'
        response = self.client.get(url)
        self.assertEqual(response.status_code, status.HTTP_400_BAD_REQUEST)
        self.assertEqual(
            response.data,
            {'non_field_errors': ['Works only in Uzbekistan.']}
        )
