# Django
from django.contrib.gis.geos import Point
from django.db import transaction

# Project
from .models import Address, Region, District
from .utils import reverse


@transaction.atomic
def address_create(longitude, latitude, landmark=''):
    response = reverse(lon=longitude, lat=latitude, language='ru')
    assert not response.get('error'), response.get('error')

    region = Region.objects.get(name=response['region'])
    district = District.objects.get(name=response['district'], region=region)
    address = response['address']

    return Address.objects.create(
        district=district,
        longitude=longitude,
        latitude=latitude,
        landmark=landmark,
        address=address,
        point=Point(longitude, latitude)
    )
