# Django Rest Framework
from rest_framework import serializers

# Project
from apps.shared.serializers import DynamicFieldsModelSerializer
from .models import Region, District, Address


class RegionSerializer(serializers.ModelSerializer):
    class Meta:
        model = Region
        fields = ('id', 'name')


class DistrictSerializer(serializers.ModelSerializer):
    region = RegionSerializer()

    class Meta:
        model = District
        fields = ('id', 'name', 'region')


class AddressSerializer(DynamicFieldsModelSerializer):
    def to_representation(self, instance):
        self.fields['district'] = DistrictSerializer()
        return super().to_representation(instance)

    class Meta:
        model = Address
        fields = (
            'id',
            'latitude',
            'longitude',
            'landmark',
            'district',
            'address'
        )
        read_only_fields = ('district', 'address')

    def update(self, instance, validated_data):
        raise NotImplemented
