# Django
from django.contrib.gis.db import models


class Region(models.Model):
    name = models.CharField(max_length=200)
    ejarima_id = models.CharField(max_length=200, null=True, unique=True)


class District(models.Model):
    region = models.ForeignKey(Region, on_delete=models.CASCADE)
    ejarima_id = models.CharField(max_length=200, null=True, unique=True)
    name = models.CharField(max_length=200)


class Address(models.Model):
    district = models.ForeignKey(
        District,
        on_delete=models.SET_NULL,
        null=True
    )
    longitude = models.FloatField()
    latitude = models.FloatField()
    point = models.PointField()
    landmark = models.CharField(max_length=255, blank=True)
    address = models.CharField(max_length=400)
