# Django Rest Framework
from rest_framework.decorators import api_view
from rest_framework.response import Response

# Project
from ..utils import reverse, search


@api_view()
def geocoder_reverse(request, version):
    lat = request.GET.get('lat')
    lon = request.GET.get('lon')

    try:
        if lat and lon:
            return Response(reverse(lat=float(lat), lon=float(lon)))
    except ValueError:
        pass
    return Response()


@api_view()
def geocoder_search(request, version):
    q = request.GET.get('q')
    if q:
        return Response(search(q))
    return Response()
