# Django Rest Framework
from rest_framework.throttling import AnonRateThrottle


class PhoneNumberThrottle(AnonRateThrottle):
    def allow_request(self, request, view):
        if self.rate is None:
            return True

        phone = request.data.get('phone')
        self.key = f"{self.get_cache_key(request, view)}_{phone}"
        if self.key is None:
            return True

        self.history = self.cache.get(self.key, [])
        self.now = self.timer()

        # Drop any requests from the history which have now passed the
        # throttle duration
        while self.history and self.history[-1] <= self.now - self.duration:
            self.history.pop()
        if len(self.history) >= self.num_requests:
            return self.throttle_failure()
        return self.throttle_success()
