# Django
from django.utils.translation import gettext as _
from django.utils import timezone
from django.conf import settings

# Project
from .models import User
from apps.shared.utils import send_sms_verification


def create_user(phone, username=None):
    if not phone.startswith('+'):
        phone = '+' + phone

    return User.objects.update_or_create(
        phone=phone,
        defaults=dict(username=username or phone)
    )


def auth_phone(phone):
    user, __ = create_user(phone)
    if user.phone == '+998917776990':
        user.sms_code = '111111'
        user.sms_date = timezone.now()
        user.save()
    else:
        send_sms_verification(
            user,
            phone,
            (_('Road24 dlya vhoda SMS-kod: %s') +
             f" {settings.SMS_APP_CODE}")
        )
