# Django
from django.db import models
from django.contrib.auth.models import (
    AbstractBaseUser, PermissionsMixin, UserManager
)
from django.utils.translation import gettext_lazy as _
from django.conf import settings

# Project
from apps.shared.models import BaseModel


class User(AbstractBaseUser, PermissionsMixin, BaseModel):
    FEMALE = 'female'
    MALE = 'male'

    GENDER_CHOICES = (
        (FEMALE, 'Female'),
        (MALE, 'Meal')
    )

    username = models.CharField(max_length=128, unique=True)
    phone = models.CharField(max_length=30, null=True, unique=True)
    is_active = models.BooleanField(default=True)
    email = models.EmailField(_('email address'), blank=True)
    gender = models.CharField(
        max_length=30,
        choices=GENDER_CHOICES,
        blank=True
    )
    birthday = models.DateTimeField(null=True)
    image = models.ForeignKey(
        'files.File',
        null=True,
        on_delete=models.SET_NULL,
        related_name='users'
    )
    is_staff = models.BooleanField(default=False)
    first_name = models.CharField(max_length=32, blank=True)
    last_name = models.CharField(max_length=32, blank=True)
    language = models.CharField(
        max_length=32,
        choices=settings.LANGUAGES,
        default='ru'
    )

    ejarima_id = models.CharField(max_length=255, null=True, unique=True)

    sms_date = models.DateTimeField(null=True)
    sms_code = models.CharField(max_length=128, blank=True)

    objects = UserManager()

    EMAIL_FIELD = 'email'
    USERNAME_FIELD = 'username'
    REQUIRED_FIELDS = ['email']

    class Meta:
        ordering = ('-id',)

    def __str__(self):
        return self.username

    def deactivate(self):
        self.is_active = False
        self.save()

    def activate(self):
        self.is_active = True
        self.save()
