# Django Rest Framework
from rest_framework.viewsets import GenericViewSet
from rest_framework.response import Response
from rest_framework.decorators import action
from rest_framework.permissions import IsAuthenticated

# Project
from apps.shared.permissions import IsSuperUserPermission
from ..serializers.users import UserSerializer, UserTokenSerializer
from ...models import User


class UserViewSet(GenericViewSet):
    queryset = User.objects.all()
    permission_classes = [IsAuthenticated]

    def get_serializer_class(self):
        if self.action == 'me':
            return UserSerializer
        return UserTokenSerializer

    def get_object(self):
        return self.request.user

    @action(methods=['GET', 'PUT'], detail=False)
    def me(self, request, pk=None, *args, **kwargs):
        method = request.method.lower()
        obj = self.get_object()
        if method == 'get':
            serializer = self.get_serializer(obj)
            response = serializer.data
        else:
            serializer = self.get_serializer(obj, data=request.data)
            serializer.is_valid(raise_exception=True)
            serializer.save()
            response = serializer.data
        return Response(response)

    @action(
        methods=['POST'],
        detail=False,
        permission_classes=[IsSuperUserPermission]
    )
    def user_token(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        return Response(serializer.save())
