# Django
from django.conf import settings

# Django Rest Framework
from rest_framework.viewsets import GenericViewSet
from rest_framework.response import Response
from rest_framework.decorators import action
from rest_framework.throttling import AnonRateThrottle, UserRateThrottle

# Project
from ..serializers.auth import AuthPhoneSerializer, AuthPhoneVerifySerializer
from ...throttle import PhoneNumberThrottle


class AuthPhoneView(GenericViewSet):
    throttle_classes = (AnonRateThrottle, UserRateThrottle)

    def get_throttles(self):
        if settings.ENV == 'production' and self.action == 'phone':
            if self.request.version == 'v2':
                self.throttle_classes = (PhoneNumberThrottle,)
            return [throttle() for throttle in self.throttle_classes]
        return []

    def get_serializer_class(self):
        if self.action == 'phone':
            return AuthPhoneSerializer
        return AuthPhoneVerifySerializer

    @action(['POST'], detail=False)
    def phone(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        return Response(serializer.save())

    @action(['POST'], detail=False)
    def phone_verify(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        return Response(serializer.save())
