# Django
from django.urls import path, include

# Django Rest Framework
from rest_framework.routers import DefaultRouter
from rest_framework_simplejwt.views import TokenRefreshView

# Project
from .views.users import UserViewSet
from .views.auth import AuthPhoneView

router = DefaultRouter()
router.register('auth', AuthPhoneView, 'auth')
router.register('', UserViewSet, 'user')

urlpatterns = [
    path('auth/token/refresh/', TokenRefreshView.as_view(),
         name='token_refresh'),
    path('', include(router.urls))
]
