# Django Rest Framework
from rest_framework import serializers
from rest_framework_simplejwt.tokens import RefreshToken

# Project
from ...models import User


class UserSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = (
            'id',
            'phone',
            'email',
            'image',
            'gender',
            'birthday',
            'first_name',
            'last_name',
            'language'
        )
        read_only_fields = ('phone', 'id')


class UserTokenSerializer(serializers.Serializer):
    phone = serializers.IntegerField()

    def validate_phone(self, phone):
        user = User.objects.filter(phone='+%d' % phone).first()

        if not user:
            raise serializers.ValidationError('Not found.')

        return user

    def to_representation(self, instance):
        return instance

    def create(self, validated_data):
        refresh = RefreshToken.for_user(validated_data['phone'])
        return {
            'refresh': str(refresh),
            'access': str(refresh.access_token),
        }
