# Django
from django.apps import AppConfig
from django.conf import settings

# Pypi: firebase
from firebase_admin import credentials, initialize_app


class GauthConfig(AppConfig):
    name = 'apps.gauth'

    def ready(self):
        try:
            initialize_app(
                credentials.Certificate(
                    settings.FIREBASE_AUTH['SERVICE_ACCOUNT_KEY_FILE']
                )
            )
        except Exception as e:
            pass
