# Django
from django.urls import path, include

# Django Rest Framework
from rest_framework.routers import DefaultRouter

# Project
from .views import UserViewSet, CustomAuthToken

router = DefaultRouter()
router.register('users', UserViewSet, 'users')

urlpatterns = [
    path('api-token-auth/', CustomAuthToken.as_view(), name='admin-auth'),
    path('', include(router.urls))
]
