# Django Rest Framework
from rest_framework import serializers

# Project
from ..models import User


class UserAdminSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = (
            "id",
            "is_superuser",
            "created_date",
            "modified_date",
            "is_deleted",
            "username",
            "password",
            "phone",
            "is_active",
            "email",
            "gender",
            "birthday",
            "first_name",
            "last_name",
            "language",
        )
        extra_kwargs = {'password': {'write_only': True}}

    @staticmethod
    def _set_password(instance, password):
        instance.set_password(password)
        instance.save()

    def update(self, instance, validated_data):
        password = validated_data.pop('password', None)
        if password:
            self._set_password(instance, password)
        return super().update(instance, validated_data)

    def create(self, validated_data):
        password = validated_data.pop('password', None)
        instance = super().create(validated_data)
        if password:
            self._set_password(instance, password)
        return instance
