# Django Rest Framework
from rest_framework import mixins
from rest_framework.permissions import IsAuthenticatedOrReadOnly
from rest_framework.viewsets import GenericViewSet
from rest_framework.parsers import MultiPartParser

# Project
from .models import File
from .serializers import FileSerializer


class FileViewSet(mixins.RetrieveModelMixin,
                  mixins.CreateModelMixin,
                  GenericViewSet):
    queryset = File.objects.all()
    permission_classes = (IsAuthenticatedOrReadOnly,)
    serializer_class = FileSerializer
    parser_classes = [MultiPartParser]
